
import gurobi as gp

# Define variables
x = gp.MultiVar(6, lb=0, name="hours_worked")

# Define objective function
obj = gp.Var(1)
obj[0] = 4.87 * x[0] + 3.0 * x[1] + 9.03 * x[2] + 7.73 * x[3] + 8.75 * x[4] + 7.94 * x[5]

# Define constraints
constrs = []
constrs.append(x[0] == 1)  # Ringo's paperwork
constrs.append(x[1] == 1)  # Mary's paperwork
constrs.append(x[2] == 1)  # Jean's paperwork
constrs.append(x[3] == 1)  # Dale's paperwork
constrs.append(x[4] == 1)  # John's paperwork
constrs.append(x[5] == 1)  # Bill's paperwork

# Add other constraints here...

# Solve model
model = gp.Model()
model.setObjective(obj, gp.GRB.MAXIMIZE)
for constr in constrs:
    model.addConstr(constr)

status = model.optimize()

if status == gp.GRB.Status.OPTIMAL:
    print("Optimal solution found.")
    for i in range(6):
        print(f"Hours worked by person {i+1}: {x[i].x}")
else:
    print("No optimal solution found.")
