
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # milligrams of magnesium
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B5
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # grams of carbohydrates
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="x3") # milligrams of vitamin B2


    # Set objective function
    m.setObjective(7.73 * x0 + 6.54 * x1 + 9.04 * x2 + 9.4 * x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(6 * x0 + 14 * x1 + 4 * x2 + 10 * x3 <= 126, "c0")
    m.addConstr(20 * x0 + 14 * x1 + 22 * x2 + 13 * x3 <= 273, "c1")
    m.addConstr(4 * x2 + 10 * x3 >= 26, "c2")
    m.addConstr(14 * x1 + 4 * x2 >= 15, "c3")
    m.addConstr(14 * x1 + 10 * x3 >= 25, "c4")
    m.addConstr(6 * x0 + 4 * x2 >= 27, "c5")
    m.addConstr(6 * x0 + 14 * x1 + 4 * x2 + 10 * x3 >= 27, "c6")
    m.addConstr(20 * x0 + 14 * x1 >= 33, "c7")
    m.addConstr(20 * x0 + 22 * x2 >= 59, "c8")
    m.addConstr(14 * x1 + 22 * x2 >= 47, "c9")
    m.addConstr(14 * x1 + 13 * x3 >= 31, "c10")
    m.addConstr(20 * x0 + 22 * x2 + 13 * x3 >= 53, "c11")
    m.addConstr(20 * x0 + 14 * x1 + 22 * x2 + 13 * x3 >= 53, "c12")
    m.addConstr(-3 * x2 + 2 * x3 >= 0, "c13")
    m.addConstr(14 * x1 + 22 * x2 <= 219, "c14")
    m.addConstr(20 * x0 + 22 * x2 <= 116, "c15")
    m.addConstr(14 * x1 + 13 * x3 <= 168, "c16")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
