
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="milligrams_of_magnesium", vtype=gurobi.GRB.INTEGER)
x1 = model.addVar(name="milligrams_of_vitamin_B5", vtype=gurobi.GRB.CONTINUOUS)
x2 = model.addVar(name="grams_of_carbohydrates", vtype=gurobi.GRB.CONTINUOUS)
x3 = model.addVar(name="milligrams_of_vitamin_B2", vtype=gurobi.GRB.INTEGER)

# Objective function
model.setObjective(7.73 * x0 + 6.54 * x1 + 9.04 * x2 + 9.4 * x3, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(6 * x0 <= 126, name="cognitive_performance_index_magnesium")
model.addConstr(20 * x0 <= 273, name="energy_stability_index_magnesium")
model.addConstr(14 * x1 <= 126, name="cognitive_performance_index_vitamin_B5")
model.addConstr(14 * x1 <= 273, name="energy_stability_index_vitamin_B5")
model.addConstr(4 * x2 <= 126, name="cognitive_performance_index_carbohydrates")
model.addConstr(22 * x2 <= 273, name="energy_stability_index_carbohydrates")
model.addConstr(10 * x3 <= 126, name="cognitive_performance_index_vitamin_B2")
model.addConstr(13 * x3 <= 273, name="energy_stability_index_vitamin_B2")

model.addConstr(4 * x2 + 10 * x3 >= 26, name="combined_cognitive_performance_index_carbohydrates_vitamin_B2")
model.addConstr(14 * x1 + 4 * x2 >= 15, name="combined_cognitive_performance_index_vitamin_B5_carbohydrates")
model.addConstr(14 * x1 + 10 * x3 >= 25, name="combined_cognitive_performance_index_vitamin_B5_vitamin_B2")
model.addConstr(6 * x0 + 4 * x2 >= 27, name="combined_cognitive_performance_index_magnesium_carbohydrates")
model.addConstr(6 * x0 + 14 * x1 + 4 * x2 + 10 * x3 >= 27, name="combined_cognitive_performance_index_all")

model.addConstr(20 * x0 + 14 * x1 >= 33, name="combined_energy_stability_index_magnesium_vitamin_B5")
model.addConstr(20 * x0 + 22 * x2 >= 59, name="combined_energy_stability_index_magnesium_carbohydrates")
model.addConstr(14 * x1 + 22 * x2 >= 47, name="combined_energy_stability_index_vitamin_B5_carbohydrates")
model.addConstr(14 * x1 + 13 * x3 >= 31, name="combined_energy_stability_index_vitamin_B5_vitamin_B2")
model.addConstr(20 * x0 + 22 * x2 + 13 * x3 >= 53, name="combined_energy_stability_index_magnesium_carbohydrates_vitamin_B2")
model.addConstr(20 * x0 + 14 * x1 + 22 * x2 + 13 * x3 >= 53, name="combined_energy_stability_index_all")

model.addConstr(-3 * x2 + 2 * x3 >= 0, name="linear_constraint")
model.addConstr(14 * x1 + 22 * x2 <= 219, name="upper_bound_combined_energy_stability_index_vitamin_B5_carbohydrates")
model.addConstr(20 * x0 + 22 * x2 <= 116, name="upper_bound_combined_energy_stability_index_magnesium_carbohydrates")
model.addConstr(14 * x1 + 13 * x3 <= 168, name="upper_bound_combined_energy_stability_index_vitamin_B5_vitamin_B2")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Milligrams of magnesium: ", x0.varValue)
    print("Milligrams of vitamin B5: ", x1.varValue)
    print("Grams of carbohydrates: ", x2.varValue)
    print("Milligrams of vitamin B2: ", x3.varValue)
else:
    print("The model is infeasible")
