
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_drumsticks")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oranges")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_cereal")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_pasta")

# Set objective function
m.setObjective(8.6 * x0 + 8.31 * x1 + 4.72 * x2 + 7.32 * x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(34 * x0 + 26 * x1 >= 56)
m.addConstr(34 * x0 + 23 * x2 >= 96)
m.addConstr(34 * x0 + 26 * x1 + 23 * x2 + 35 * x3 >= 96)
m.addConstr(11 * x0 + 29 * x1 >= 16)
m.addConstr(5 * x2 + 10 * x3 >= 29)
m.addConstr(11 * x0 + 5 * x2 >= 48)
m.addConstr(11 * x0 + 29 * x1 + 5 * x2 + 10 * x3 >= 48)
m.addConstr(23 * x0 + 14 * x3 >= 28)
m.addConstr(26 * x1 + 14 * x3 >= 30)
m.addConstr(23 * x0 + 17 * x2 >= 41)
m.addConstr(23 * x0 + 26 * x1 + 17 * x2 + 14 * x3 >= 41)
m.addConstr(34 * x0 + 26 * x1 <= 252)
m.addConstr(26 * x1 + 35 * x3 <= 150)
m.addConstr(23 * x2 + 35 * x3 <= 393)
m.addConstr(29 * x1 + 5 * x2 <= 112)
m.addConstr(11 * x0 + 5 * x2 <= 173)
m.addConstr(29 * x1 + 10 * x3 <= 98)
m.addConstr(11 * x0 + 10 * x3 <= 149)
m.addConstr(11 * x0 + 29 * x1 <= 190)

# Resource Constraints
m.addConstr(34 * x0 + 26 * x1 + 23 * x2 + 35 * x3 <= 397)
m.addConstr(11 * x0 + 29 * x1 + 5 * x2 + 10 * x3 <= 203)
m.addConstr(23 * x0 + 26 * x1 + 17 * x2 + 14 * x3 <= 174)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

