
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="chicken_drumsticks", lb=-float('inf'), ub=float('inf'))
    x1 = model.addVar(name="oranges", lb=-float('inf'), ub=float('inf'))
    x2 = model.addVar(name="bowls_of_cereal", lb=-float('inf'), ub=float('inf'))
    x3 = model.addVar(name="bowls_of_pasta", lb=-float('inf'), ub=float('inf'))

    # Define the objective function
    model.setObjective(8.6 * x0 + 8.31 * x1 + 4.72 * x2 + 7.32 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(34 * x0 + 26 * x1 >= 56)
    model.addConstr(34 * x0 + 23 * x2 >= 96)
    model.addConstr(34 * x0 + 26 * x1 + 23 * x2 + 35 * x3 >= 96)
    model.addConstr(11 * x0 + 29 * x1 >= 16)
    model.addConstr(5 * x2 + 10 * x3 >= 29)
    model.addConstr(11 * x0 + 5 * x2 >= 48)
    model.addConstr(11 * x0 + 29 * x1 + 5 * x2 + 10 * x3 >= 48)
    model.addConstr(23 * x0 + 14 * x3 >= 28)
    model.addConstr(26 * x1 + 14 * x3 >= 30)
    model.addConstr(23 * x0 + 17 * x2 >= 41)
    model.addConstr(23 * x0 + 26 * x1 + 17 * x2 + 14 * x3 >= 41)
    model.addConstr(34 * x0 + 26 * x1 <= 252)
    model.addConstr(26 * x1 + 35 * x3 <= 150)
    model.addConstr(23 * x2 + 35 * x3 <= 393)
    model.addConstr(29 * x1 + 5 * x2 <= 112)
    model.addConstr(11 * x0 + 5 * x2 <= 173)
    model.addConstr(26 * x1 + 10 * x3 <= 98)
    model.addConstr(11 * x0 + 10 * x3 <= 149)
    model.addConstr(11 * x0 + 29 * x1 <= 190)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Chicken drumsticks: ", x0.x)
        print("Oranges: ", x1.x)
        print("Bowls of cereal: ", x2.x)
        print("Bowls of pasta: ", x3.x)
    else:
        print("The model is infeasible")

solve_optimization_problem()
