
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(1*x1 + 6*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9*x1 + 2*x2 >= 9, name="cognitive_performance_index")
    model.addConstr(2*x1 + 14*x2 >= 16, name="immune_support_index")
    model.addConstr(-10*x1 + 4*x2 >= 0, name="linear_constraint_1")
    model.addConstr(9*x1 + 2*x2 <= 19, name="cognitive_performance_index_upper_bound")
    model.addConstr(2*x1 + 14*x2 <= 31, name="immune_support_index_upper_bound")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
