
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.CONTINUOUS, name="x0") # milligrams of vitamin B6
    x1 = m.addVar(vtype=GRB.INTEGER, name="x1") # milligrams of vitamin B2
    x2 = m.addVar(vtype=GRB.INTEGER, name="x2") # milligrams of zinc


    # Set objective function
    m.setObjective(9*x0**2 + x0*x2 + 2*x1**2 + x1*x2 + x2**2 + 6*x0 + 3*x1 + x2, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8.88*x0 + 14.45*x1 >= 25, "c0")
    m.addConstr(8.88*x0 + 5.8*x2 >= 30, "c1")
    m.addConstr(14.45*x1 + 5.8*x2 >= 24, "c2")
    m.addConstr(8.88*x0 + 14.45*x1 + 5.8*x2 >= 24, "c3")
    m.addConstr(12.48*x0 + 8.29*x2 >= 88, "c4")
    m.addConstr(10.75*x1**2 + 8.29*x2**2 >= 89, "c5")
    m.addConstr(12.48*x0 + 10.75*x1 + 8.29*x2 >= 89, "c6")
    m.addConstr(10*x0 - 5*x2 >= 0, "c7")
    m.addConstr(2*x1 - 3*x2 >= 0, "c8")
    m.addConstr(2*x0 - 5*x1 >= 0, "c9")
    m.addConstr(14.45*x1**2 + 5.8*x2**2 <= 77, "c10")
    m.addConstr(8.88*x0 + 14.45*x1 + 5.8*x2 <= 134, "c11")
    m.addConstr(12.48*x0 + 8.29*x2 <= 357, "c12")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
