
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="x0", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.CONTINUOUS)
x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.CONTINUOUS)
x2 = model.addVar(name="x2", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(9*x0**2 + x0*x2 + 2*x1**2 + x1*x2 + x2**2 + 6*x0 + 3*x1 + x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(8.88*x0 <= 157)
model.addConstr(12.48*x0 <= 435)
model.addConstr(14.45*x1 <= 157)
model.addConstr(10.75*x1 <= 435)
model.addConstr(5.8*x2 <= 157)
model.addConstr(8.29*x2 <= 435)
model.addConstr(8.88*x0 + 14.45*x1 >= 25)
model.addConstr(8.88*x0 + 5.8*x2 >= 30)
model.addConstr(14.45*x1 + 5.8*x2 >= 24)
model.addConstr(8.88*x0 + 14.45*x1 + 5.8*x2 >= 24)
model.addConstr(12.48*x0 + 8.29*x2 >= 88)
model.addConstr(10.75*x1**2 + 8.29*x2**2 >= 89)
model.addConstr(12.48*x0 + 10.75*x1 + 8.29*x2 >= 89)
model.addConstr(10*x0 - 5*x2 >= 0)
model.addConstr(2*x1 - 3*x2 >= 0)
model.addConstr(2*x0 - 5*x1 >= 0)
model.addConstr(14.45*x1**2 + 5.8*x2**2 <= 77)
model.addConstr(8.88*x0 + 14.45*x1 + 5.8*x2 <= 134)
model.addConstr(12.48*x0 + 8.29*x2 <= 357)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
else:
    print("The model is infeasible")
