
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(4, name=["color_printers", "lanyards", "mechanical_pencils", "red_highlighters"], vtype=gp.GRB.INTEGER)


    # Set objective function
    m.setObjective(6*x[0] + 1*x[1] + 4*x[2] + 6*x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(32*x[0] + 14*x[1] + 13*x[2] >= 92)
    m.addConstr(32*x[0] + 13*x[2] + 30*x[3] >= 92)
    m.addConstr(32*x[0] + 14*x[1] + 13*x[2] >= 65)
    m.addConstr(32*x[0] + 13*x[2] + 30*x[3] >= 65)
    m.addConstr(15*x[0] + 25*x[1] >= 20)
    m.addConstr(15*x[2] + 30*x[3] >= 26)
    m.addConstr(25*x[1] + 15*x[2] + 30*x[3] >= 42)
    m.addConstr(15*x[0] + 15*x[2] + 30*x[3] >= 42)
    m.addConstr(25*x[1] + 15*x[2] + 30*x[3] >= 35)
    m.addConstr(15*x[0] + 15*x[2] + 30*x[3] >= 35)
    m.addConstr(14*x[1] + 13*x[2] <= 314)
    m.addConstr(14*x[1] + 30*x[3] <= 116)
    m.addConstr(13*x[2] + 30*x[3] <= 143)
    m.addConstr(32*x[0] + 14*x[1] + 13*x[2] <= 321)
    m.addConstr(32*x[0] + 13*x[2] + 30*x[3] <= 311)
    m.addConstr(14*x[1] + 13*x[2] + 30*x[3] <= 336)
    m.addConstr(32*x[0] + 14*x[1] + 13*x[2] + 30*x[3] <= 336)
    m.addConstr(25*x[1] + 30*x[3] <= 62)
    m.addConstr(25*x[1] + 15*x[2] <= 167)
    m.addConstr(15*x[0] + 30*x[3] <= 127)
    m.addConstr(15*x[0] + 25*x[1] + 15*x[2] <= 184)
    m.addConstr(15*x[0] + 15*x[2] + 30*x[3] <= 216)
    m.addConstr(25*x[1] + 15*x[2] + 30*x[3] <= 67)
    m.addConstr(15*x[0] + 25*x[1] + 15*x[2] + 30*x[3] <= 67)
    m.addConstr(32*x[0] + 14*x[1] + 13*x[2] + 30*x[3] <= 395)
    m.addConstr(15*x[0] + 25*x[1] + 15*x[2] + 30*x[3] <= 233)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Obj: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
