
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # color printers
x1 = m.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # lanyards
x2 = m.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # mechanical pencils
x3 = m.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # red highlighters

# Define the objective function
m.setObjective(6 * x0 + 1 * x1 + 4 * x2 + 6 * x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(32 * x0 + 14 * x1 + 13 * x2 >= 92)
m.addConstr(32 * x0 + 13 * x2 + 30 * x3 >= 92)
m.addConstr(32 * x0 + 14 * x1 + 13 * x2 >= 65)
m.addConstr(32 * x0 + 13 * x2 + 30 * x3 >= 65)
m.addConstr(15 * x0 + 25 * x1 >= 20)
m.addConstr(15 * x2 + 30 * x3 >= 26)
m.addConstr(25 * x1 + 15 * x2 + 30 * x3 >= 42)
m.addConstr(15 * x0 + 15 * x2 + 30 * x3 >= 42)
m.addConstr(25 * x1 + 15 * x2 + 30 * x3 >= 35)
m.addConstr(15 * x0 + 15 * x2 + 30 * x3 >= 35)
m.addConstr(14 * x1 + 13 * x2 <= 314)
m.addConstr(14 * x1 + 30 * x3 <= 116)
m.addConstr(13 * x2 + 30 * x3 <= 143)
m.addConstr(32 * x0 + 14 * x1 + 13 * x2 <= 321)
m.addConstr(32 * x0 + 13 * x2 + 30 * x3 <= 311)
m.addConstr(14 * x1 + 13 * x2 + 30 * x3 <= 336)
m.addConstr(32 * x0 + 14 * x1 + 13 * x2 + 30 * x3 <= 336)
m.addConstr(25 * x1 + 30 * x3 <= 62)
m.addConstr(25 * x1 + 15 * x2 <= 167)
m.addConstr(15 * x0 + 30 * x3 <= 127)
m.addConstr(15 * x0 + 25 * x1 + 15 * x2 <= 184)
m.addConstr(15 * x0 + 15 * x2 + 30 * x3 <= 216)
m.addConstr(25 * x1 + 15 * x2 + 30 * x3 <= 67)
m.addConstr(15 * x0 + 25 * x1 + 15 * x2 + 30 * x3 <= 67)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Color printers: ", x0.varValue)
    print("Lanyards: ", x1.varValue)
    print("Mechanical pencils: ", x2.varValue)
    print("Red highlighters: ", x3.varValue)
else:
    print("The model is infeasible")
