
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of magnesium
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # grams of carbohydrates
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin B4
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of vitamin A


    # Set objective function
    m.setObjective(8.48 * x0 + 5.91 * x1 + 6.67 * x2 + 5.11 * x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4.39 * x0 + 6.81 * x1 >= 50, "c0")
    m.addConstr(4.39 * x0 + 0.77 * x2 >= 66, "c1")
    m.addConstr(6.81 * x1 + 3.47 * x3 >= 73, "c2")
    m.addConstr(4.39 * x0 + 6.81 * x1 + 0.77 * x2 + 3.47 * x3 >= 73, "c3")
    m.addConstr(-2 * x0 + x1 >= 0, "c4")
    m.addConstr(-10 * x2 + 3 * x3 >= 0, "c5")
    m.addConstr(4.39 * x0 + 3.47 * x3 <= 366, "c6")
    m.addConstr(4.39 * x0 + 0.77 * x2 + 3.47 * x3 <= 431, "c7")
    m.addConstr(4.39 * x0 + 6.81 * x1 + 0.77 * x2 <= 435, "c8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
