
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_magnesium", lb=-gurobi.GRB.INFINITY)  # Can be negative
    x2 = model.addVar(name="grams_of_carbohydrates", lb=-gurobi.GRB.INFINITY)  # Can be negative
    x3 = model.addVar(name="milligrams_of_vitamin_B4", lb=-gurobi.GRB.INFINITY)  # Can be negative
    x4 = model.addVar(name="milligrams_of_vitamin_A", lb=-gurobi.GRB.INFINITY)  # Can be negative

    # Objective function
    model.setObjective(8.48 * x1 + 5.91 * x2 + 6.67 * x3 + 5.11 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4.39 * x1 + 6.81 * x2 >= 50)
    model.addConstr(4.39 * x1 + 0.77 * x3 >= 66)
    model.addConstr(6.81 * x2 + 3.47 * x4 >= 73)
    model.addConstr(4.39 * x1 + 6.81 * x2 + 0.77 * x3 + 3.47 * x4 >= 73)
    model.addConstr(-2 * x1 + x2 >= 0)
    model.addConstr(-10 * x3 + 3 * x4 >= 0)
    model.addConstr(4.39 * x1 + 3.47 * x4 <= 366)
    model.addConstr(4.39 * x1 + 0.77 * x3 + 3.47 * x4 <= 431)
    model.addConstr(4.39 * x1 + 6.81 * x2 + 0.77 * x3 <= 435)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of magnesium: {x1.varValue}")
        print(f"Grams of carbohydrates: {x2.varValue}")
        print(f"Milligrams of vitamin B4: {x3.varValue}")
        print(f"Milligrams of vitamin A: {x4.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
