
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0, ub=None)  # hours worked by Laura
    x1 = model.addVar(name="x1", lb=0, ub=None)  # hours worked by Bobby
    x2 = model.addVar(name="x2", lb=0, ub=None)  # hours worked by Peggy
    x3 = model.addVar(name="x3", lb=0, ub=None)  # hours worked by Dale
    x4 = model.addVar(name="x4", lb=0, ub=None)  # hours worked by John

    # Objective function
    model.setObjective(5 * x0 + 7 * x1 + x2 + 3 * x3 + 6 * x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(9 * x0 <= 317)
    model.addConstr(19 * x0 <= 750)
    model.addConstr(15 * x1 <= 317)
    model.addConstr(5 * x1 <= 750)
    model.addConstr(6 * x2 <= 317)
    model.addConstr(11 * x2 <= 750)
    model.addConstr(20 * x3 <= 317)
    model.addConstr(11 * x3 <= 750)
    model.addConstr(17 * x4 <= 317)
    model.addConstr(6 * x4 <= 750)

    model.addConstr(9 * x0 + 20 * x3 >= 57)
    model.addConstr(6 * x2 + 17 * x4 >= 62)
    model.addConstr(9 * x0 + 17 * x4 >= 53)
    model.addConstr(9 * x0 + 6 * x2 + 17 * x4 >= 44)
    model.addConstr(15 * x1 + 6 * x2 + 17 * x4 >= 44)
    model.addConstr(15 * x1 + 20 * x3 + 17 * x4 >= 44)
    model.addConstr(6 * x2 + 20 * x3 + 17 * x4 >= 44)
    model.addConstr(9 * x0 + 6 * x2 + 17 * x4 >= 54)
    model.addConstr(15 * x1 + 6 * x2 + 17 * x4 >= 54)
    model.addConstr(15 * x1 + 20 * x3 + 17 * x4 >= 54)
    model.addConstr(6 * x2 + 20 * x3 + 17 * x4 >= 54)

    model.addConstr(5 * x1 + 11 * x2 >= 150)
    model.addConstr(19 * x0 + 11 * x3 >= 75)
    model.addConstr(19 * x0 + 6 * x4 >= 104)
    model.addConstr(5 * x1 + 11 * x3 >= 117)
    model.addConstr(19 * x0 + 5 * x1 >= 79)
    model.addConstr(19 * x0 + 5 * x1 + 11 * x3 >= 147)

    model.addConstr(3 * x1 - 3 * x2 >= 0)
    model.addConstr(9 * x0 + 17 * x4 <= 171)
    model.addConstr(15 * x1 + 20 * x3 <= 120)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Laura: ", x0.varValue)
        print("Hours worked by Bobby: ", x1.varValue)
        print("Hours worked by Peggy: ", x2.varValue)
        print("Hours worked by Dale: ", x3.varValue)
        print("Hours worked by John: ", x4.varValue)
    else:
        print("No solution found")

optimization_problem()
