
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    zinc = m.addVar(lb=0, name="zinc")  # milligrams of zinc
    b6 = m.addVar(lb=0, name="b6")  # milligrams of vitamin B6

    # Set objective function
    m.setObjective(8.82 * zinc + 1.66 * b6, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(26 * zinc + 29 * b6 >= 85, "kidney_support_min")
    m.addConstr(7 * zinc + 4 * b6 >= 60, "cardiovascular_support_min")
    m.addConstr(28 * zinc + 7 * b6 >= 24, "cognitive_performance_min")
    m.addConstr(-6 * zinc + 4 * b6 >= 0, "zinc_b6_ratio")
    m.addConstr(26 * zinc + 29 * b6 <= 158, "kidney_support_max")
    m.addConstr(7 * zinc + 4 * b6 <= 119, "cardiovascular_support_max")
    m.addConstr(28 * zinc + 7 * b6 <= 89, "cognitive_performance_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Optimal objective value: %g' % m.objVal)
        print('Zinc: %g' % zinc.x)
        print('Vitamin B6: %g' % b6.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')

