
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name="milligrams_of_zinc", lb=-GRB.INFINITY, ub=GRB.INFINITY)
x1 = m.addVar(name="milligrams_of_vitamin_B6", lb=-GRB.INFINITY, ub=GRB.INFINITY)

# Set the objective function
m.setObjective(8.82*x0 + 1.66*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(26*x0 + 29*x1 >= 85, name="kidney_support_index_min")
m.addConstr(7*x0 + 4*x1 >= 60, name="cardiovascular_support_index_min")
m.addConstr(28*x0 + 7*x1 >= 24, name="cognitive_performance_index_min")
m.addConstr(-6*x0 + 4*x1 >= 0, name="linear_constraint")
m.addConstr(26*x0 + 29*x1 <= 158, name="kidney_support_index_max")
m.addConstr(7*x0 + 4*x1 <= 119, name="cardiovascular_support_index_max")
m.addConstr(28*x0 + 7*x1 <= 89, name="cognitive_performance_index_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of zinc: {x0.x}")
    print(f"Milligrams of vitamin B6: {x1.x}")
else:
    print("No optimal solution found")
