
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="milligrams_of_zinc", lb=0)  # No lower bound specified, assuming 0
x2 = model.addVar(name="milligrams_of_vitamin_B6", lb=0)  # No lower bound specified, assuming 0

# Define the objective function
model.setObjective(8.82 * x1 + 1.66 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(26 * x1 <= 181, name="kidney_support_index_zinc")
model.addConstr(7 * x1 <= 223, name="cardiovascular_support_index_zinc")
model.addConstr(28 * x1 <= 131, name="cognitive_performance_index_zinc")
model.addConstr(29 * x2 <= 181, name="kidney_support_index_vitamin_B6")
model.addConstr(4 * x2 <= 223, name="cardiovascular_support_index_vitamin_B6")
model.addConstr(7 * x2 <= 131, name="cognitive_performance_index_vitamin_B6")
model.addConstr(26 * x1 + 29 * x2 >= 85, name="combined_kidney_support_index_min")
model.addConstr(7 * x1 + 4 * x2 >= 60, name="combined_cardiovascular_support_index_min")
model.addConstr(28 * x1 + 7 * x2 >= 24, name="combined_cognitive_performance_index_min")
model.addConstr(-6 * x1 + 4 * x2 >= 0, name="zinc_vitamin_B6_relation")
model.addConstr(26 * x1 + 29 * x2 <= 158, name="combined_kidney_support_index_max")
model.addConstr(7 * x1 + 4 * x2 <= 119, name="combined_cardiovascular_support_index_max")
model.addConstr(28 * x1 + 7 * x2 <= 89, name="combined_cognitive_performance_index_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of zinc: {x1.varValue}")
    print(f"Milligrams of vitamin B6: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
