
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")  # grams of fiber
    x2 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, vtype='I', name="x2")  # milligrams of vitamin E
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3")  # milligrams of vitamin B9
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x4")  # milligrams of potassium
    x5 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, vtype='I', name="x5")  # milligrams of vitamin D
    x6 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, vtype='I', name="x6")  # milligrams of magnesium

    # Objective function
    model.setObjective(5.44 * x1 + 8.62 * x2 + 9.19 * x3 + 5.25 * x4 + 3.47 * x5 + 3.21 * x6, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2 * x1 + 11 * x2 + 4 * x3 + 9 * x4 + 8 * x5 + 7 * x6 <= 138)
    model.addConstr(4 * x3 + 7 * x6 >= 13)
    model.addConstr(11 * x2 + 7 * x6 >= 7)
    model.addConstr(2 * x1 + 9 * x4 >= 13)
    model.addConstr(11 * x2 + 8 * x5 >= 23)
    model.addConstr(11 * x2 + 4 * x3 >= 16)
    model.addConstr(4 * x3 + 9 * x4 >= 19)
    model.addConstr(2 * x1 + 7 * x6 >= 11)
    model.addConstr(2 * x1 + 8 * x5 >= 19)
    model.addConstr(2 * x1 + 11 * x2 >= 17)
    model.addConstr(8 * x5 + 7 * x6 >= 17)
    model.addConstr(9 * x4 + 8 * x5 >= 20)
    model.addConstr(2 * x1 + 11 * x2 + 7 * x6 >= 22)
    model.addConstr(11 * x2 + 4 * x3 + 9 * x4 >= 22)
    model.addConstr(11 * x2 + 8 * x5 + 7 * x6 >= 22)
    model.addConstr(9 * x4 + 8 * x5 + 7 * x6 >= 22)
    model.addConstr(2 * x1 + 11 * x2 + 8 * x5 >= 22)
    model.addConstr(4 * x3 + 9 * x4 + 8 * x5 >= 22)
    model.addConstr(11 * x2 + 9 * x4 + 7 * x6 >= 22)
    model.addConstr(2 * x1 + 8 * x5 + 7 * x6 >= 22)
    model.addConstr(2 * x1 + 11 * x2 + 4 * x3 >= 22)
    model.addConstr(2 * x1 + 4 * x3 + 8 * x5 >= 22)
    model.addConstr(4 * x3 + 9 * x4 + 7 * x6 >= 22)
    model.addConstr(11 * x2 + 4 * x3 + 8 * x5 >= 22)

    # ... add other constraints similarly

    model.addConstr(2 * x3 - 9 * x4 >= 0)
    model.addConstr(2 * x5 - 3 * x6 >= 0)
    model.addConstr(10 * x2 - 9 * x5 >= 0)
    model.addConstr(9 * x4 + 8 * x5 <= 31)
    model.addConstr(2 * x1 + 8 * x5 <= 72)
    model.addConstr(4 * x3 + 9 * x4 <= 134)
    model.addConstr(2 * x1 + 4 * x3 <= 48)
    model.addConstr(2 * x1 + 9 * x4 <= 52)
    model.addConstr(8 * x5 + 7 * x6 <= 94)
    model.addConstr(2 * x1 + 7 * x6 <= 103)

    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objval)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
        print("x4: ", x4.varValue)
        print("x5: ", x5.varValue)
        print("x6: ", x6.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
