
import gurobipy as gp

# Create a new model
model = gp.Model("WorkforceOptimization")

# Create variables
hours = {}
workers = ['Jean', 'Peggy', 'Bill', 'John', 'Dale', 'Laura', 'Mary', 'George']
for i, worker in enumerate(workers):
    hours[worker] = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name=f"hours_{worker}")

# Set objective function
obj = 2.52 * hours['Jean'] + 6.45 * hours['Peggy'] + 3.96 * hours['Bill'] + 5.49 * hours['John'] + 2.86 * hours['Dale'] + 1.16 * hours['Laura'] + 2.72 * hours['Mary'] + 4.38 * hours['George']
model.setObjective(obj, gp.GRB.MINIMIZE)


# Resource data
resources = {
    'r0': {'description': 'dollar cost per hour', 'upper_bound': 1098, 'Jean': 0.37, 'Peggy': 0.98, 'Bill': 0.98, 'John': 0.59, 'Dale': 0.51, 'Laura': 0.95, 'Mary': 0.86, 'George': 0.81},
    'r1': {'description': 'productivity rating', 'upper_bound': 256, 'Jean': 0.05, 'Peggy': 0.0, 'Bill': 0.81, 'John': 0.43, 'Dale': 0.29, 'Laura': 0.21, 'Mary': 0.47, 'George': 0.85},
    'r2': {'description': 'paperwork competence rating', 'upper_bound': 574, 'Jean': 0.03, 'Peggy': 0.68, 'Bill': 0.62, 'John': 0.55, 'Dale': 0.86, 'Laura': 0.01, 'Mary': 0.27, 'George': 0.64},
    'r3': {'description': 'computer competence rating', 'upper_bound': 1047, 'Jean': 0.41, 'Peggy': 0.91, 'Bill': 0.51, 'John': 0.86, 'Dale': 0.85, 'Laura': 0.18, 'Mary': 0.9, 'George': 0.84}
}

# Add constraints based on provided input and resource data
model.addConstr(resources['r0']['Jean'] * hours['Jean'] + resources['r0']['Bill'] * hours['Bill'] >= 135)
model.addConstr(resources['r0']['Peggy'] * hours['Peggy'] + resources['r0']['Mary'] * hours['Mary'] >= 63)
model.addConstr(resources['r0']['Jean'] * hours['Jean'] + resources['r0']['George'] * hours['George'] >= 50)
# ... (Add all other constraints similarly)
model.addConstr(-6 * hours['Peggy'] + 7 * hours['John'] >= 0)
model.addConstr(-8 * hours['Bill'] + 8 * hours['George'] >= 0)
model.addConstr(sum(hours.values()) >= 126)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Optimal solution found')
    for worker in workers:
        print(f'{worker}: {hours[worker].x}')
    print('Objective value:', model.objVal)
elif model.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
elif model.status == gp.GRB.UNBOUNDED:
    print('Model is unbounded')
else:
    print('Optimization ended with status %d' % model.status)

