
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    iron = m.addVar(vtype=gp.GRB.CONTINUOUS, name="iron")
    vitamin_c = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
    fiber = m.addVar(vtype=gp.GRB.CONTINUOUS, name="fiber")

    # Set objective function
    m.setObjective(1.3 * iron + 6.78 * vitamin_c + 8.38 * fiber, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2 * vitamin_c + 6 * fiber >= 78, "kidney_support_1")
    m.addConstr(33 * iron + 6 * fiber <= 331, "kidney_support_2")
    m.addConstr(2 * vitamin_c + 6 * fiber <= 166, "kidney_support_3")
    m.addConstr(33 * iron + 2 * vitamin_c + 6 * fiber <= 166, "kidney_support_4")
    m.addConstr(4 * vitamin_c + 25 * fiber <= 87, "cognitive_performance_1")
    m.addConstr(6 * iron + 4 * vitamin_c <= 113, "cognitive_performance_2")
    m.addConstr(6 * iron + 4 * vitamin_c + 25 * fiber <= 113, "cognitive_performance_3")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Optimal objective value: %g' % m.objVal)
        print('iron:', iron.x)
        print('vitamin_c:', vitamin_c.x)
        print('fiber:', fiber.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    elif m.status == gp.GRB.UNBOUNDED:
        print('Model is unbounded')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

