
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='milligrams_of_iron', lb=-gurobi.GRB.INFINITY)
    x1 = model.addVar(name='milligrams_of_vitamin_C', lb=-gurobi.GRB.INFINITY)
    x2 = model.addVar(name='grams_of_fiber', lb=-gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(1.3*x0 + 6.78*x1 + 8.38*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2*x1 + 6*x2 >= 78)
    model.addConstr(33*x0 + 6*x2 <= 331)
    model.addConstr(2*x1 + 6*x2 <= 166)
    model.addConstr(33*x0 + 2*x1 + 6*x2 <= 166)
    model.addConstr(4*x1 + 25*x2 <= 87)
    model.addConstr(6*x0 + 4*x1 <= 113)
    model.addConstr(6*x0 + 4*x1 + 25*x2 <= 113)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'milligrams of iron: {x0.varValue}')
        print(f'milligrams of vitamin C: {x1.varValue}')
        print(f'grams of fiber: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
