
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="grams_of_carbohydrates")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams_of_zinc")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams_of_vitamin_K")


    # Set objective function
    m.setObjective(8*x0 + 3*x1 + 2*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(12.5*x0 + 19.96*x1 + 12.75*x2 >= 58, "c0")
    m.addConstr(11.97*x0 + 20.9*x1 + 6.86*x2 >= 79, "c1")
    m.addConstr(-x1 + x2 >= 0, "c2")
    m.addConstr(12.5*x0 + 19.96*x1 <= 132, "c3")
    m.addConstr(19.96*x1 + 12.75*x2 <= 145, "c4")
    m.addConstr(12.5*x0 + 19.96*x1 + 12.75*x2 <= 90, "c5")
    m.addConstr(20.9*x1 + 6.86*x2 <= 236, "c6")
    m.addConstr(11.97*x0 + 20.9*x1 <= 251, "c7")
    m.addConstr(11.97*x0 + 20.9*x1 + 6.86*x2 <= 251, "c8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
