
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="x1", lb=0)  # grams of carbohydrates
    x2 = model.addVar(name="x2", lb=0)  # milligrams of zinc
    x3 = model.addVar(name="x3", lb=0)  # milligrams of vitamin K

    # Objective function
    model.setObjective(8*x1 + 3*x2 + 2*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(12.5*x1 + 19.96*x2 + 12.75*x3 >= 58)
    model.addConstr(11.97*x1 + 20.9*x2 + 6.86*x3 >= 79)
    model.addConstr(-x2 + x3 >= 0)
    model.addConstr(12.5*x1 + 19.96*x2 <= 132)
    model.addConstr(19.96*x2 + 12.75*x3 <= 145)
    model.addConstr(12.5*x1 + 19.96*x2 + 12.75*x3 <= 90)
    model.addConstr(20.9*x2 + 6.86*x3 <= 236)
    model.addConstr(11.97*x1 + 20.9*x2 <= 251)
    model.addConstr(11.97*x1 + 20.9*x2 + 6.86*x3 <= 251)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"x1 (grams of carbohydrates): {x1.varValue}")
        print(f"x2 (milligrams of zinc): {x2.varValue}")
        print(f"x3 (milligrams of vitamin K): {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
