
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize Labor Cost")

    # Create variables
    peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")  # hours worked by Peggy
    mary = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")  # hours worked by Mary
    jean = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean")  # hours worked by Jean


    # Set objective function
    model.setObjective(8*peggy + 2*mary + 3*jean, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9*mary + 1*jean >= 7, "c1")
    model.addConstr(12*peggy + 9*mary + 1*jean >= 7, "c2")
    model.addConstr(2*peggy + 1*mary >= 10, "c3")
    model.addConstr(1*mary + 10*jean >= 13, "c4")
    model.addConstr(2*peggy + 10*jean >= 16, "c5")
    model.addConstr(2*peggy + 1*mary + 10*jean >= 16, "c6")
    model.addConstr(-8*peggy + 5*mary >= 0, "c7")
    model.addConstr(8*mary - 7*jean >= 0, "c8")
    model.addConstr(2*peggy + 1*mary <= 32, "c9")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Peggy: {peggy.x}")
        print(f"Mary: {mary.x}")
        print(f"Jean: {jean.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
