
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='x0', lb=0)  # hours worked by Peggy
    x1 = model.addVar(name='x1', lb=0)  # hours worked by Mary
    x2 = model.addVar(name='x2', lb=0)  # hours worked by Jean

    # Define the objective function
    model.setObjective(8*x0 + 2*x1 + 3*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9*x1 + x2 >= 7)
    model.addConstr(12*x0 + 9*x1 + x2 >= 7)
    model.addConstr(2*x0 + x1 >= 10)
    model.addConstr(x1 + 10*x2 >= 13)
    model.addConstr(2*x0 + 10*x2 >= 16)
    model.addConstr(2*x0 + x1 + 10*x2 >= 16)
    model.addConstr(-8*x0 + 5*x1 >= 0)
    model.addConstr(8*x1 - 7*x2 >= 0)
    model.addConstr(2*x0 + x1 <= 32)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Hours worked by Peggy: ', x0.varValue)
        print('Hours worked by Mary: ', x1.varValue)
        print('Hours worked by Jean: ', x2.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
