
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(lb=0, name="milligrams of vitamin B1")  # Continuous
x1 = m.addVar(lb=0, type=gurobi.GRB.INTEGER, name="milligrams of vitamin B7")  # Integer
x2 = m.addVar(lb=0, name="grams of carbohydrates")  # Continuous
x3 = m.addVar(lb=0, name="grams of fiber")  # Continuous

# Objective function
m.setObjective(8 * x0 + x1 + x2 + 2 * x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(0.98 * x1 + 0.33 * x2 + 1.43 * x3 >= 44)
m.addConstr(1.31 * x0 + 0.98 * x1 + 0.33 * x2 + 1.43 * x3 >= 44)
m.addConstr(0.85 * x0 + 1.8 * x2 >= 60)
m.addConstr(1.8 * x2 + 1.16 * x3 >= 49)
m.addConstr(0.85 * x0 + 1.16 * x3 >= 56)
m.addConstr(0.85 * x0 + 0.04 * x1 + 1.8 * x2 + 1.16 * x3 >= 56)
m.addConstr(9 * x2 - 9 * x3 >= 0)
m.addConstr(-2 * x1 + 9 * x3 >= 0)
m.addConstr(1.31 * x0 + 0.33 * x2 <= 76)
m.addConstr(0.33 * x2 + 1.43 * x3 <= 191)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"x0: {x0.varValue}")
    print(f"x1: {x1.varValue}")
    print(f"x2: {x2.varValue}")
    print(f"x3: {x3.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
