
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    bobby = model.addVar(vtype=GRB.INTEGER, name="bobby")
    mary = model.addVar(vtype=GRB.INTEGER, name="mary")
    ringo = model.addVar(vtype=GRB.INTEGER, name="ringo")

    # Set objective function
    model.setObjective(4 * bobby + 7 * mary + 8 * ringo, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3 * bobby + 2 * mary >= 14, "c0")
    model.addConstr(2 * mary + 16 * ringo >= 30, "c1")
    model.addConstr(3 * bobby + 16 * ringo >= 28, "c2")
    model.addConstr(3 * bobby + 2 * mary + 16 * ringo >= 28, "c3")
    model.addConstr(11 * bobby + 13 * ringo >= 37, "c4")
    model.addConstr(3 * mary + 13 * ringo >= 32, "c5")
    model.addConstr(11 * bobby + 3 * mary + 13 * ringo >= 32, "c6")
    model.addConstr(13 * bobby + 5 * mary >= 44, "c7")
    model.addConstr(13 * bobby + 5 * mary + 15 * ringo >= 44, "c8")
    model.addConstr(-4 * bobby + 7 * mary >= 0, "c9")
    model.addConstr(3 * bobby + 16 * ringo <= 80, "c10")
    model.addConstr(3 * mary + 13 * ringo <= 103, "c11")
    model.addConstr(11 * bobby + 13 * ringo <= 53, "c12")
    model.addConstr(11 * bobby + 3 * mary + 13 * ringo <= 99, "c13")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('Bobby:', bobby.x)
        print('Mary:', mary.x)
        print('Ringo:', ringo.x)
    elif model.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
