
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", vtype=gp.GRB.INTEGER)  # hours worked by Bobby
x1 = m.addVar(name="x1", vtype=gp.GRB.INTEGER)  # hours worked by Mary
x2 = m.addVar(name="x2", vtype=gp.GRB.INTEGER)  # hours worked by Ringo

# Define the objective function
m.setObjective(4 * x0 + 7 * x1 + 8 * x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * x0 <= 112)
m.addConstr(11 * x0 <= 114)
m.addConstr(13 * x0 <= 140)
m.addConstr(2 * x1 <= 112)
m.addConstr(3 * x1 <= 114)
m.addConstr(5 * x1 <= 140)
m.addConstr(16 * x2 <= 112)
m.addConstr(13 * x2 <= 114)
m.addConstr(15 * x2 <= 140)
m.addConstr(3 * x0 + 2 * x1 >= 14)
m.addConstr(2 * x1 + 16 * x2 >= 30)
m.addConstr(3 * x0 + 16 * x2 >= 28)
m.addConstr(3 * x0 + 2 * x1 + 16 * x2 >= 28)
m.addConstr(11 * x0 + 13 * x2 >= 37)
m.addConstr(3 * x1 + 13 * x2 >= 32)
m.addConstr(11 * x0 + 3 * x1 + 13 * x2 >= 32)
m.addConstr(13 * x0 + 5 * x1 >= 44)
m.addConstr(13 * x0 + 5 * x1 + 15 * x2 >= 44)
m.addConstr(-4 * x0 + 7 * x1 >= 0)
m.addConstr(3 * x0 + 16 * x2 <= 80)
m.addConstr(3 * x1 + 13 * x2 <= 103)
m.addConstr(11 * x0 + 13 * x2 <= 53)
m.addConstr(11 * x0 + 3 * x1 + 13 * x2 <= 99)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Bobby: ", x0.varValue)
    print("Hours worked by Mary: ", x1.varValue)
    print("Hours worked by Ringo: ", x2.varValue)
else:
    print("The model is infeasible")
