
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
knishes = m.addVar(lb=0, name="knishes")
ravioli = m.addVar(lb=0, name="ravioli")
cantaloupes = m.addVar(lb=0, name="cantaloupes")
chicken_thighs = m.addVar(lb=0, name="chicken_thighs")

# Set objective function
m.setObjective(3.6*knishes**2 + 8.76*knishes*ravioli + 8.77*knishes*cantaloupes + 5.38*knishes*chicken_thighs + 5.13*cantaloupes**2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10.29*knishes**2 + 5.24*cantaloupes**2 >= 24)
m.addConstr(5.24*cantaloupes**2 + 4.29*chicken_thighs**2 >= 29)
m.addConstr(10.29*knishes + 4.29*chicken_thighs >= 21)
m.addConstr(8.15*ravioli + 5.24*cantaloupes >= 30)
m.addConstr(10.29*knishes + 8.15*ravioli + 5.24*cantaloupes + 4.29*chicken_thighs >= 30)
m.addConstr(1.94*knishes + 9.01*cantaloupes >= 18)
m.addConstr(8.63*ravioli + 9.01*cantaloupes >= 19)
m.addConstr(1.94*knishes + 8.63*ravioli >= 13)
m.addConstr(1.94*knishes**2 + 4.03*chicken_thighs**2 >= 20)
m.addConstr(8.63*ravioli + 9.01*cantaloupes + 4.03*chicken_thighs >= 20)
m.addConstr(1.94*knishes + 8.63*ravioli + 9.01*cantaloupes + 4.03*chicken_thighs >= 20)
m.addConstr(-3*knishes + 2*ravioli >= 0)
m.addConstr(5.24*cantaloupes + 4.29*chicken_thighs <= 63)
m.addConstr(10.29*knishes + 4.29*chicken_thighs <= 72)
m.addConstr(8.63*ravioli**2 + 4.03*chicken_thighs**2 <= 42)
m.addConstr(1.94*knishes + 8.63*ravioli + 4.03*chicken_thighs <= 74)
m.addConstr(1.94*knishes + 8.63*ravioli + 9.01*cantaloupes <= 62)
m.addConstr(1.94*knishes + 9.01*cantaloupes + 4.03*chicken_thighs <= 45)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

