
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B9")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B6")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_K")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")
x4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B4")
x5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fiber")


# Set objective function
m.setObjective(8.11*x0 + 2.51*x1 + 1.72*x2 + 8.54*x3 + 2.94*x4 + 9.14*x5, gp.GRB.MINIMIZE)

# Add constraints

m.addConstr(6.31*x1 + 8.37*x3 >= 30)
m.addConstr(5.01*x2 + 8.37*x3 >= 68)
m.addConstr(6.31*x0 + 7.59*x5 >= 54)
m.addConstr(5.04*x1 + 6.46*x4 >= 30)
m.addConstr(6.31*x0 + 5.01*x2 + 6.46*x4 >= 75)
m.addConstr(6.31*x0 + 8.37*x3 + 7.59*x5 >= 75)
m.addConstr(6.31*x0 + 5.04*x1 + 8.37*x3 >= 75)
m.addConstr(6.31*x0 + 8.37*x3 + 6.46*x4 >= 75)
m.addConstr(8.37*x3 + 6.46*x4 + 7.59*x5 >= 75)
m.addConstr(5.04*x1 + 5.01*x2 + 6.46*x4 >= 75)
m.addConstr(5.01*x2 + 8.37*x3 + 6.46*x4 >= 75)
m.addConstr(5.04*x1 + 5.01*x2 + 7.59*x5 >= 75)
m.addConstr(6.31*x0 + 5.04*x1 + 7.59*x5 >= 75)
m.addConstr(6.31 * x0 + 5.01 * x2 + 6.46 * x4 >= 70)
m.addConstr(6.31 * x0 + 8.37 * x3 + 7.59 * x5 >= 70)
m.addConstr(6.31 * x0 + 5.04 * x1 + 8.37 * x3 >= 70)
m.addConstr(6.31 * x0 + 8.37 * x3 + 6.46 * x4 >= 70)
m.addConstr(8.37 * x3 + 6.46 * x4 + 7.59 * x5 >= 70)
m.addConstr(5.04 * x1 + 5.01 * x2 + 6.46 * x4 >= 70)
m.addConstr(5.01 * x2 + 8.37 * x3 + 6.46 * x4 >= 70)
m.addConstr(5.04 * x1 + 5.01 * x2 + 7.59 * x5 >= 70)
m.addConstr(6.31 * x0 + 5.04 * x1 + 7.59 * x5 >= 70)


m.addConstr(6.31*x0 + 7.59*x5 <= 267)
m.addConstr(6.31*x0 + 8.37*x3 + 6.46*x4 <= 468)
m.addConstr(6.31*x0 + 5.04*x1 + 5.01*x2 <= 486)
m.addConstr(5.04*x1 + 5.01*x2 + 6.46*x4 <= 364)
m.addConstr(5.01*x2 + 6.46*x4 + 7.59*x5 <= 375)
m.addConstr(6.31*x0 + 5.04*x1 + 7.59*x5 <= 476)


m.addConstr(11.01*x0 + 4.26*x1 >= 63)
m.addConstr(10.93*x4 + 9.82*x5 >= 93)
m.addConstr(10.34*x2 + 9.82*x5 >= 63)
m.addConstr(11.01*x0 + 9.82*x5 >= 77)
m.addConstr(11.01*x0 + 4.26*x1 + 10.34*x2 + 6.88*x3 + 10.93*x4 + 9.82*x5 >= 77)
m.addConstr(5*x1 - 8*x3 >= 0)
m.addConstr(11.01*x0 + 4.26*x1 <= 206)
m.addConstr(11.01*x0 + 10.34*x2 <= 675)
m.addConstr(10.34*x2 + 9.82*x5 <= 670)
m.addConstr(10.93*x4 + 9.82*x5 <= 385)
m.addConstr(4.26*x1 + 10.34*x2 <= 613)
m.addConstr(10.34*x2 + 10.93*x4 <= 538)
m.addConstr(4.26*x1 + 10.93*x4 <= 270)
m.addConstr(4.26*x1 + 6.88*x3 <= 377)
m.addConstr(4.26*x1 + 9.82*x5 <= 286)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

