
import gurobipy as gp

# Create a new model
model = gp.Model("resource_optimization")

# Create variables
honeypots = model.addVar(vtype=gp.GRB.INTEGER, name="honeypots")
system_admins = model.addVar(vtype=gp.GRB.INTEGER, name="system_admins")
soc_operators = model.addVar(vtype=gp.GRB.INTEGER, name="soc_operators")


# Set objective function
model.setObjective(8.84*honeypots**2 + 8.8*honeypots*system_admins + 1.26*honeypots*soc_operators + 2.7*system_admins**2 + 7.63*system_admins*soc_operators + 5.13*soc_operators**2 + 7.0*honeypots + 9.9*system_admins + 7.02*soc_operators, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*honeypots + 6*soc_operators >= 16)
model.addConstr(9*honeypots**2 + 7*soc_operators**2 >= 20)
model.addConstr(1*honeypots + 3*system_admins >= 15)
model.addConstr(9*system_admins + 6*soc_operators >= 13)
model.addConstr(2*honeypots**2 + 9*system_admins**2 >= 7)
model.addConstr(4*system_admins**2 + 16*soc_operators**2 <= 106)
model.addConstr(honeypots**2 + 4*system_admins**2 <= 133)
model.addConstr(honeypots + 2*system_admins + 4*soc_operators <= 133)
model.addConstr(5*honeypots + 6*soc_operators <= 47)
model.addConstr(121*system_admins**2 + 36*soc_operators**2 <= 49)
model.addConstr(5*honeypots + 11*system_admins <= 33)
model.addConstr(5*honeypots + 11*system_admins + 6*soc_operators <= 33)
model.addConstr(5*system_admins + 7*soc_operators <= 32)
model.addConstr(9*honeypots + 7*soc_operators <= 63)
model.addConstr(9*honeypots + 5*system_admins + 7*soc_operators <= 63)
model.addConstr(honeypots + 8*soc_operators <= 53)
model.addConstr(honeypots**2 + 9*system_admins**2 <= 59)
model.addConstr(honeypots + 3*system_admins + 8*soc_operators <= 59)
model.addConstr(9*system_admins + 6*soc_operators <= 18)
model.addConstr(2*honeypots + 9*system_admins <= 28)
model.addConstr(2*honeypots + 9*system_admins + 6*soc_operators <= 28)



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print("Variable values:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

