
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="honeypots", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="system_administrators", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="SOC_operators", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(8.84*x1**2 + 8.8*x1*x2 + 1.26*x1*x3 + 2.7*x2**2 + 7.63*x2*x3 + 5.13*x3**2 + 7.0*x1 + 9.9*x2 + 7.02*x3, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + 2*x2 + 4*x3 <= 202)
m.addConstr(5*x1 + 11*x2 + 6*x3 <= 79)
m.addConstr(9*x1 + 5*x2 + 7*x3 <= 98)
m.addConstr(x1 + 3*x2 + 8*x3 <= 62)
m.addConstr(2*x1 + 9*x2 + 6*x3 <= 48)
m.addConstr(5*x1 + 6*x3 >= 16)
m.addConstr(9*x1**2 + 7*x3**2 >= 20)
m.addConstr(x1 + 3*x2 >= 15)
m.addConstr(9*x2 + 6*x3 >= 13)
m.addConstr(4*x1**2 + 9*x2**2 >= 7)
m.addConstr(4*x2**2 + 16*x3**2 <= 106)
m.addConstr(x1**2 + 4*x2**2 <= 133)
m.addConstr(x1 + 2*x2 + 4*x3 <= 133)
m.addConstr(5*x1 + 6*x3 <= 47)
m.addConstr(121*x2**2 + 36*x3**2 <= 49)
m.addConstr(5*x1 + 11*x2 <= 33)
m.addConstr(5*x1 + 11*x2 + 6*x3 <= 33)
m.addConstr(5*x2 + 7*x3 <= 32)
m.addConstr(9*x1 + 7*x3 <= 63)
m.addConstr(9*x1 + 5*x2 + 7*x3 <= 63)
m.addConstr(x1 + 8*x3 <= 53)
m.addConstr(x1**2 + 9*x2**2 <= 59)
m.addConstr(x1 + 3*x2 + 8*x3 <= 59)
m.addConstr(9*x2 + 6*x3 <= 18)
m.addConstr(2*x1 + 9*x2 <= 28)
m.addConstr(2*x1 + 9*x2 + 6*x3 <= 28)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Honeypots: ", x1.varValue)
    print("System Administrators: ", x2.varValue)
    print("SOC Operators: ", x3.varValue)
else:
    print("The model is infeasible")
