
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
bagged_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bagged_salads")
potatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")


# Set objective function
m.setObjective(1 * bagged_salads + 4 * potatoes, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4.0 * bagged_salads + 0.84 * potatoes >= 39, "calcium_min")
m.addConstr(12.96 * bagged_salads + 15.92 * potatoes >= 59, "sourness_min")
m.addConstr(-5 * bagged_salads + 8 * potatoes >= 0, "proportion_constraint")
m.addConstr(4.0 * bagged_salads + 0.84 * potatoes <= 100, "calcium_max")
m.addConstr(12.96 * bagged_salads + 15.92 * potatoes <= 80, "sourness_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('bagged_salads:', bagged_salads.x)
    print('potatoes:', potatoes.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

