
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bagged_salads")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potatoes")

# Set the objective function
m.setObjective(1*x0 + 4*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(4.0*x0 + 0.84*x1 >= 39, "calcium_lower_bound")
m.addConstr(12.96*x0 + 15.92*x1 >= 59, "sourness_lower_bound")
m.addConstr(-5*x0 + 8*x1 >= 0, "linear_combination_constraint")
m.addConstr(4.0*x0 + 0.84*x1 <= 100, "calcium_upper_bound")
m.addConstr(12.96*x0 + 15.92*x1 <= 80, "sourness_upper_bound")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bagged Salads: {x0.x}")
    print(f"Potatoes: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
