
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="bagged_salads", lb=0)  # Assuming non-negative
    x2 = model.addVar(name="potatoes", lb=0)    # Assuming non-negative

    # Objective function: minimize 1*x1 + 4*x2
    model.setObjective(x1 + 4 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4.0 * x1 + 0.84 * x2 >= 39, name="calcium_constraint")
    model.addConstr(12.96 * x1 + 15.92 * x2 >= 59, name="sourness_index_constraint")
    model.addConstr(-5 * x1 + 8 * x2 >= 0, name="another_constraint")
    model.addConstr(4.0 * x1 + 0.84 * x2 <= 100, name="upper_bound_calcium")
    model.addConstr(12.96 * x1 + 15.92 * x2 <= 80, name="upper_bound_sourness")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bagged Salads: {x1.varValue}")
        print(f"Potatoes: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
