
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    dale_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale_hours")
    bobby_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby_hours")


    # Set objective function
    model.setObjective(2.31 * dale_hours + 9.7 * bobby_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4 * dale_hours + 10 * bobby_hours >= 7, "computer_competence_min")
    model.addConstr(11 * dale_hours + 6 * bobby_hours >= 20, "organization_score_min")
    model.addConstr(11 * dale_hours + 11 * bobby_hours >= 9, "work_quality_min")
    model.addConstr(-1 * dale_hours + 8 * bobby_hours >= 0, "dale_bobby_relation")
    model.addConstr(4 * dale_hours + 10 * bobby_hours <= 16, "computer_competence_max")
    model.addConstr(11 * dale_hours + 6 * bobby_hours <= 51, "organization_score_max")
    model.addConstr(11 * dale_hours + 11 * bobby_hours <= 35, "work_quality_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Dale: {dale_hours.x}")
        print(f"Hours worked by Bobby: {bobby_hours.x}")
        print(f"Objective Value: {model.objVal}")


except gp.GurobiError as e:
    print(f"Gurobi Error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check if the model optimized correctly.")

