
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, name="hours_worked_by_Dale")
x1 = m.addVar(lb=0, name="hours_worked_by_Bobby")

# Set the objective function
m.setObjective(2.31*x0 + 9.7*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x0 + 10*x1 >= 7, "computer_competence_rating")
m.addConstr(11*x0 + 6*x1 >= 20, "organization_score")
m.addConstr(11*x0 + 11*x1 >= 9, "work_quality_rating")
m.addConstr(-x0 + 8*x1 >= 0, "additional_linear_constraint")
m.addConstr(4*x0 + 10*x1 <= 16, "computer_competence_upper_bound")
m.addConstr(11*x0 + 6*x1 <= 51, "organization_score_upper_bound")
m.addConstr(11*x0 + 11*x1 <= 35, "work_quality_rating_upper_bound")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Dale: {x0.x}")
    print(f"Hours worked by Bobby: {x1.x}")
else:
    print("No optimal solution found")
