
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_Dale", lb=0)
    x2 = model.addVar(name="hours_worked_by_Bobby", lb=0)

    # Objective function
    model.setObjective(2.31 * x1 + 9.7 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4 * x1 + 10 * x2 >= 7, name="computer_competence_rating")
    model.addConstr(11 * x1 + 6 * x2 >= 20, name="organization_score")
    model.addConstr(11 * x1 + 11 * x2 >= 9, name="work_quality_rating")
    model.addConstr(-x1 + 8 * x2 >= 0, name="dale_bobby_hours")
    model.addConstr(4 * x1 + 10 * x2 <= 25, name="computer_competence_upper_bound")
    model.addConstr(11 * x1 + 6 * x2 <= 56, name="organization_upper_bound")
    model.addConstr(11 * x1 + 11 * x2 <= 49, name="work_quality_upper_bound")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Dale: {x1.varValue}")
        print(f"Hours worked by Bobby: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
