
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="strips of bacon")
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="fruit salads")
    x2 = m.addVar(vtype=GRB.INTEGER, name="ham sandwiches")


    # Set objective function
    m.setObjective(2*x0**2 + 5*x0*x1 + x1**2 + x1*x2 + 9*x0 + 7*x1 + x2, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8*x1**2 + 8*x2**2 >= 22, "c1")
    m.addConstr(7*x0 + 8*x2 >= 22, "c2")
    m.addConstr(7*x0 + 8*x1 + 8*x2 >= 22, "c3")
    m.addConstr(3*x1 + 6*x2 >= 8, "c4")
    m.addConstr(7*x0**2 + 3*x1**2 >= 20, "c5")
    m.addConstr(7*x0 + 3*x1 + 6*x2 >= 20, "c6")
    m.addConstr(2*x1 + 6*x2 >= 18, "c7")
    m.addConstr(8*x0**2 + 6*x2**2 >= 20, "c8")
    m.addConstr(8*x0 + 2*x1 + 6*x2 >= 22, "c9")
    m.addConstr(4*x1 - 5*x2 >= 0, "c10")
    m.addConstr(10*x0**2 - 5*x2**2 >= 0, "c11")
    m.addConstr(7*x0 + 8*x1 <= 74, "c12")
    m.addConstr(8*x1 + 8*x2 <= 75, "c13")
    m.addConstr(7*x0 + 6*x2 <= 57, "c14")
    m.addConstr(7*x0**2 + 3*x1**2 + 6*x2**2 <= 53, "c15")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
