
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
pasta = m.addVar(lb=0, name="pasta")
apples = m.addVar(lb=0, name="apples")
hot_dogs = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hot_dogs")


# Set objective function
m.setObjective(2 * pasta + 9 * apples + 5 * hot_dogs, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * pasta + 6 * apples + 9 * hot_dogs >= 13, "iron_min")
m.addConstr(7 * apples + 7 * hot_dogs >= 17, "carbs_apples_hot_dogs_min")
m.addConstr(4 * pasta + 7 * hot_dogs >= 15, "carbs_pasta_hot_dogs_min")
m.addConstr(7 * apples + 2 * hot_dogs >= 22, "fiber_apples_hot_dogs_min")
m.addConstr(11 * pasta + 2 * hot_dogs >= 18, "fiber_pasta_hot_dogs_min")
m.addConstr(7 * pasta + 9 * hot_dogs <= 25, "iron_pasta_hot_dogs_max")

# Resource Constraints
m.addConstr(7 * pasta + 6 * apples + 9 * hot_dogs <= 65, "iron_max")
m.addConstr(4 * pasta + 7 * apples + 7 * hot_dogs <= 93, "carbs_max")
m.addConstr(11 * pasta + 7 * apples + 2 * hot_dogs <= 130, "fiber_max")
m.addConstr(10 * pasta + 10 * apples + 7 * hot_dogs <= 91, "cost_max")


m.addConstr(4 * pasta + 7 * hot_dogs <= 56, "carbs_pasta_hot_dogs_max")
m.addConstr(7 * apples + 7 * hot_dogs <= 83, "carbs_apples_hot_dogs_max")
m.addConstr(11 * pasta + 2 * hot_dogs <= 84, "fiber_pasta_hot_dogs_max")
m.addConstr(11 * pasta + 7 * apples <= 100, "fiber_pasta_apples_max")
m.addConstr(10 * apples + 7 * hot_dogs <= 73, "cost_apples_hot_dogs_max")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('pasta:', pasta.x)
    print('apples:', apples.x)
    print('hot_dogs:', hot_dogs.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

