
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="bowls_of_pasta", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x1 = m.addVar(name="apples", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = m.addVar(name="hot_dogs", lb=0, ub=gurobi.GRB.INFINITY, integrality=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(2 * x0 + 9 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * x0 + 6 * x1 + 9 * x2 >= 13)
m.addConstr(7 * x1 + 7 * x2 >= 17)
m.addConstr(4 * x0 + 7 * x2 >= 15)
m.addConstr(7 * x1 + 2 * x2 >= 22)
m.addConstr(11 * x0 + 2 * x2 >= 18)
m.addConstr(7 * x0 + 6 * x1 + 9 * x2 <= 25)
m.addConstr(4 * x0 + 7 * x2 <= 56)
m.addConstr(7 * x1 + 7 * x2 <= 83)
m.addConstr(4 * x0 + 7 * x1 + 7 * x2 <= 93)
m.addConstr(11 * x0 + 2 * x2 <= 84)
m.addConstr(11 * x0 + 7 * x1 <= 100)
m.addConstr(11 * x0 + 7 * x1 + 2 * x2 <= 100)
m.addConstr(10 * x1 + 7 * x2 <= 73)
m.addConstr(10 * x0 + 10 * x1 + 7 * x2 <= 73)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("bowls of pasta: ", x0.varValue)
    print("apples: ", x1.varValue)
    print("hot dogs: ", x2.varValue)
else:
    print("The model is infeasible")
