
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="SOC_operators", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="network_administrators", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(9 * x1**2 + 6 * x2**2, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(0.86 * x1 + 0.09 * x2 >= 20)
m.addConstr(0.64**2 * x1**2 + 0.79**2 * x2**2 >= 13)
m.addConstr(0.64 * x1 + 0.79 * x2 >= 13)
m.addConstr(0.34 * x1 + 0.12 * x2 >= 23)
m.addConstr(7 * x1**2 - 6 * x2**2 >= 0)
m.addConstr((0.86 * x1)**2 + (0.09 * x2)**2 <= 76)
m.addConstr(0.64**2 * x1**2 + 0.79**2 * x2**2 <= 32)
m.addConstr(0.34**2 * x1**2 + 0.12**2 * x2**2 <= 68)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("SOC operators: ", x1.varValue)
    print("Network administrators: ", x2.varValue)
else:
    print("The model is infeasible")
