
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x = m.addVars(6, lb=0, vtype=gp.GRB.CONTINUOUS, names=[
    "hours worked by Jean",
    "hours worked by Bill",
    "hours worked by George",
    "hours worked by Mary",
    "hours worked by Bobby",
    "hours worked by Dale"
])


# Set objective function
m.setObjective(2.72 * x[0] + 7.57 * x[1] + 3.16 * x[2] + 7.71 * x[3] + 8.86 * x[4] + 1.53 * x[5], gp.GRB.MAXIMIZE)

# Resource coefficients
resource_coeffs = {
    'r0': [1.52, 3.77, 2.03, 0.63, 0.36, 2.01],  # dollar cost per hour
    'r1': [3.34, 1.65, 0.87, 0.8, 1.07, 2.32],  # work quality rating
    'r2': [3.35, 3.51, 3.55, 2.15, 2.95, 2.94],  # paperwork competence rating
    'r3': [2.17, 3.85, 1.45, 3.03, 1.07, 3.57]  # productivity rating
}

# Resource upper bounds
resource_bounds = {
    'r0': 872,
    'r1': 413,
    'r2': 533,
    'r3': 264
}


# Add constraints from the JSON "constraints" field.
json_constraints = {
    # ... (paste the constraints from the JSON output here)
}

for constraint_str in json_constraints["constraints"]:
    lhs, op, rhs = constraint_str.split()
    rhs = float(rhs)
    lhs_terms = lhs.split("+")
    lhs_expr = 0
    for term in lhs_terms:
        factors = term.split("*")
        if len(factors) == 2:
            coeff, var_name = factors
            var_index = json_constraints["sym_variables"].index(tuple(var_name.split("x")))
            lhs_expr += float(coeff) * x[var_index]
        else:  # single variable
            var_name = factors[0]
            var_index = json_constraints["sym_variables"].index(tuple(var_name.split("x")))
            lhs_expr += x[var_index]
    if op == ">=":
        m.addConstr(lhs_expr >= rhs)
    elif op == "<=":
        m.addConstr(lhs_expr <= rhs)
    elif op == "=":
        m.addConstr(lhs_expr == rhs)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

