
from gurobipy import *

# Create a new model
m = Model("Work Optimization")

# Define variables
x1, x2, x3, x4, x5, x6 = m.addVars(6, name=['Jean', 'Bill', 'George', 'Mary', 'Bobby', 'Dale'])

# Objective function: For demonstration, maximize total hours worked
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6, GRB.MAXIMIZE)

# Add constraints (example constraints based on the symbolic representation)
m.addConstr(x1 + x6 <= 86, name='Productivity constraint')
m.addConstr(10*x4 + 15*x5 <= 168, name='Cost constraint')
m.addConstr(x1 + x6 <= 153, name='Work quality constraint')
m.addConstr(x1 + x5 <= 224, name='Paperwork competence constraint')

# Add more constraints here based on the problem description

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
