
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="reconnaissance_troops", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="logistics_companies", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="medical_platoons", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(6*x0**2 + 5*x0*x1 + 9*x1**2 + 3*x1*x2 + 6*x2**2 + x0, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2.32*x0 + 1.72*x2 <= 26)
    model.addConstr(2.32*x0 + 4.68*x1 <= 17)
    model.addConstr(2.32*x0 + 4.68*x1 + 1.72*x2 <= 17)
    model.addConstr(4.38*x1**2 + 2.0*x2**2 <= 35)
    model.addConstr(4.51*x0 + 2.0*x2 <= 29)
    model.addConstr(4.51*x0 + 4.38*x1 + 2.0*x2 <= 29)

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Reconnaissance troops: {x0.varValue}")
        print(f"Logistics companies: {x1.varValue}")
        print(f"Medical platoons: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
