
import gurobi as grb

# Create a new model
m = grb.Model()

# Define the variables
x1 = m.addVar(name="grams_of_fiber", lb=0, ub=grb.GRB.INFINITY)
x2 = m.addVar(name="milligrams_of_vitamin_B9", lb=0, ub=grb.GRB.INFINITY, vtype=grb.GRB.INTEGER)
x3 = m.addVar(name="grams_of_protein", lb=0, ub=grb.GRB.INFINITY, vtype=grb.GRB.INTEGER)

# Define the objective function
m.setObjective(9.54 * x1 + 4.75 * x2 + 3.24 * x3, grb.GRB.MINIMIZE)

# Add constraints
m.addConstr(0.49 * x2 + 1.04 * x1 >= 117)
m.addConstr(1.04 * x1 + 0.26 * x3 >= 109)
m.addConstr(1.04 * x1 + 0.49 * x2 + 0.26 * x3 >= 109)
m.addConstr(2.48 * x1 + 0.8 * x3 >= 93)
m.addConstr(2.48 * x1 + 0.03 * x2 >= 46)
m.addConstr(2.48 * x1 + 0.03 * x2 + 0.8 * x3 >= 46)
m.addConstr(0.44 * x1 + 2.45 * x3 >= 85)
m.addConstr(0.44 * x1 + 0.64 * x2 >= 34)
m.addConstr(0.44 * x1 + 0.64 * x2 + 2.45 * x3 >= 34)
m.addConstr(6 * x2 - 8 * x3 >= 0)
m.addConstr(2 * x1 - 3 * x2 >= 0)
m.addConstr(0.49 * x2 + 0.26 * x3 <= 148)
m.addConstr(0.44 * x1 + 0.64 * x2 <= 156)

# Update model
m.update()

# Solve the model
m.optimize()

# Print the solution
if m.status == grb.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Grams of fiber: ", x1.varValue)
    print("Milligrams of vitamin B9: ", x2.varValue)
    print("Grams of protein: ", x3.varValue)
else:
    print("The model is infeasible")
