
from gurobipy import *

# Create a new model
model = Model("Vitamin_Optimization")

# Create variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_C")
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="grams_of_fiber")
x3 = model.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_B3")

# Set the objective function
model.setObjective(6*x1 + 6*x2 + 2*x3, GRB.MINIMIZE)

# Add constraints
model.addConstr(4*x1 + 5*x2 >= 14, "cognitive_performance_index_1")
model.addConstr(5*x2 + 1*x3 >= 7, "cognitive_performance_index_2")
model.addConstr(4*x1 + 5*x2 + 1*x3 >= 17, "total_cognitive_performance_index")
model.addConstr(-7*x2 + 7*x3 >= 0, "constraint_8")
model.addConstr(-5*x1 + x3 >= 0, "constraint_9")
model.addConstr(-x1 + 10*x2 >= 0, "constraint_10")
model.addConstr(5*x2 + 1*x3 <= 26, "max_cognitive_performance_index")

# Optimize model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin C: {x1.x}")
    print(f"Grams of Fiber: {x2.x}")
    print(f"Milligrams of Vitamin B3: {x3.x}")
else:
    print("No optimal solution found")
