
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin C")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="grams of fiber")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="milligrams of vitamin B3")

    # Objective function
    model.setObjective(6 * x1 + 6 * x2 + 2 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4 * x1 <= 60)
    model.addConstr(5 * x2 <= 60)
    model.addConstr(x3 <= 60)
    model.addConstr(4 * x1 + 5 * x2 >= 14)
    model.addConstr(5 * x2 + x3 >= 7)
    model.addConstr(4 * x1 + 5 * x2 + x3 >= 17)
    model.addConstr(-7 * x2 + 7 * x3 >= 0)
    model.addConstr(-5 * x1 + x3 >= 0)
    model.addConstr(-x1 + 10 * x2 >= 0)
    model.addConstr(5 * x2 + x3 <= 26)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin C: {x1.varValue}")
        print(f"Grams of fiber: {x2.varValue}")
        print(f"Milligrams of vitamin B3: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
