
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("plant_optimization")

    # Create variables
    agave = m.addVar(vtype=gp.GRB.INTEGER, name="agave")
    chives = m.addVar(vtype=gp.GRB.INTEGER, name="chives")
    boxwoods = m.addVar(vtype=gp.GRB.INTEGER, name="boxwoods")

    # Set objective function
    m.setObjective(5 * agave + 3 * chives + 5 * boxwoods, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3 * agave + 5 * chives >= 3, "c1")
    m.addConstr(3 * agave + 5 * chives + 2 * boxwoods >= 4, "c2")
    m.addConstr(5 * agave + 1 * chives >= 24, "c3")
    m.addConstr(1 * chives + 3 * boxwoods >= 20, "c4")
    m.addConstr(5 * agave + 3 * boxwoods >= 15, "c5")
    m.addConstr(5 * agave + 1 * chives + 3 * boxwoods >= 19, "c6")
    m.addConstr(2 * chives + 4 * boxwoods >= 13, "c7")
    m.addConstr(3 * agave + 5 * chives <= 27, "c8")
    m.addConstr(5 * chives + 2 * boxwoods <= 10, "c9")
    m.addConstr(3 * agave + 5 * chives + 2 * boxwoods <= 20, "c10")
    m.addConstr(5 * agave + 1 * chives <= 70, "c11")
    m.addConstr(1 * chives + 3 * boxwoods <= 95, "c12")
    m.addConstr(5 * agave + 3 * boxwoods <= 47, "c13")
    m.addConstr(5 * agave + 1 * chives + 3 * boxwoods <= 47, "c14")
    m.addConstr(4 * agave + 4 * boxwoods <= 36, "c15")
    m.addConstr(2 * chives + 4 * boxwoods <= 27, "c16")
    m.addConstr(4 * agave + 2 * chives + 4 * boxwoods <= 27, "c17")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
