
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="agave", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="chives", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="boxwoods", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(5*x0 + 3*x1 + 5*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x0 + 5*x1 >= 3)
m.addConstr(3*x0 + 5*x1 + 2*x2 >= 4)
m.addConstr(5*x0 + x1 >= 24)
m.addConstr(x1 + 3*x2 >= 20)
m.addConstr(5*x0 + 3*x2 >= 15)
m.addConstr(5*x0 + x1 + 3*x2 >= 19)
m.addConstr(2*x1 + 4*x2 >= 13)
m.addConstr(3*x0 + 5*x1 <= 27)
m.addConstr(5*x1 + 2*x2 <= 10)
m.addConstr(3*x0 + 5*x1 + 2*x2 <= 20)
m.addConstr(5*x0 + 3*x2 <= 47)
m.addConstr(5*x0 + x1 <= 70)
m.addConstr(x1 + 3*x2 <= 95)
m.addConstr(5*x0 + x1 + 3*x2 <= 47)
m.addConstr(4*x0 + 4*x2 <= 36)
m.addConstr(2*x1 + 4*x2 <= 27)
m.addConstr(4*x0 + 2*x1 + 4*x2 <= 27)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Agave: ", x0.varValue)
    print("Chives: ", x1.varValue)
    print("Boxwoods: ", x2.varValue)
else:
    print("The model is infeasible")
