
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    vitamin_e = m.addVar(lb=0, name="vitamin_e")  # milligrams of vitamin E
    zinc = m.addVar(lb=0, name="zinc")  # milligrams of zinc


    # Set objective function
    m.setObjective(1.63 * vitamin_e + 8.5 * zinc, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(0.6 * vitamin_e + 1.85 * zinc >= 21, "muscle_growth_min")
    m.addConstr(1.24 * vitamin_e + 1.83 * zinc >= 21, "immune_support_min")
    m.addConstr(7 * vitamin_e - 5 * zinc >= 0, "constraint_3")
    m.addConstr(0.6 * vitamin_e + 1.85 * zinc <= 33, "muscle_growth_max")
    m.addConstr(1.24 * vitamin_e + 1.83 * zinc <= 26, "immune_support_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Vitamin E: %g' % vitamin_e.x)
        print('Zinc: %g' % zinc.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

